<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- Print Documentation for links-->
	<xsl:template name="printLinksEx">
		<xsl:param name="element"></xsl:param>
		<xsl:param name="metaclasses"></xsl:param>
		<xsl:param name="link_refs"></xsl:param>
			
		<xsl:variable name="first" select="$metaclasses[1]"></xsl:variable>
		<xsl:if test="$first">
	
			<xsl:variable name="p_name" select="string($first)"></xsl:variable>

			<xsl:if test="string-length($p_name) &gt; 0">
			<!-- Heading (small table with link metaclass inside) -->
			<p/>
			<table border="0" cellpadding="0" cellspacing="0">
			<tr class="TableHeaderStyle">
			<td>
			<font size="+0">
			<b><xsl:value-of select="$p_name"/></b>
			</font>
			</td>
			</tr>
			</table>
			<br/>

			<!-- Links of selected metaclass -->
			<xsl:for-each select="$element/Link[@metaclass=$p_name]">

				<xsl:variable name="destination" select="key('all-by-id', @idref)"></xsl:variable>
				<xsl:variable name="ref">
					<xsl:call-template name="RelPathResolver">
						<xsl:with-param name="element" select="$destination"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
	
				<xsl:variable name="to">
					<xsl:choose>
						<xsl:when test="local-name($destination)='Package'">
							<xsl:call-template name="getLocalizedResource">
								<xsl:with-param name="code" select="'Package_1'"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="local-name($destination)='Classifier'">
							<xsl:call-template name="getLocalizedClassType">
								<xsl:with-param name="type" select="$destination/@type"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$destination/@metaclass"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<xsl:variable name="refpath">
					<xsl:apply-templates select="$destination" mode="HRefWithImgLoad"/>
				</xsl:variable>

				<xsl:choose>
					<xsl:when test="string-length(string($ref)) &gt; 0">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
							<xsl:with-param name="p1" select="$to"></xsl:with-param>
							<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
							<xsl:with-param name="p1" select="$to"></xsl:with-param>
							<xsl:with-param name="p2" select="$destination/@name"></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<p/>
				<xsl:call-template name="printProperties">
					<xsl:with-param name="element" select="current()"></xsl:with-param>
					<xsl:with-param name="nodeset" select="Property"></xsl:with-param>
					<xsl:with-param name="property-names" select="Property/@name"></xsl:with-param>			
				</xsl:call-template>
				
				<xsl:variable name="reference" select="$link_refs[@element=current()/@id]"></xsl:variable>
				<xsl:variable name="refproperties" select="$reference/Property"></xsl:variable>
				<xsl:call-template name="printProperties">
					<xsl:with-param name="element" select="$reference"></xsl:with-param>
					<xsl:with-param name="nodeset" select="$refproperties[not(@name=current()/Property/@name)]"></xsl:with-param>
					<xsl:with-param name="property-names" select="$refproperties[not(@name=current()/Property/@name)]/@name"></xsl:with-param>
				</xsl:call-template>
				<br/>
			</xsl:for-each>
			</xsl:if>
			<xsl:call-template name="printLinksEx">
				<xsl:with-param name="element" select="$element"></xsl:with-param>
				<xsl:with-param name="metaclasses" select="$metaclasses[not(string($p_name)=string(.))]"></xsl:with-param>
				<xsl:with-param name="link_refs" select="$link_refs"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!-- Print Documentation for links-->
	<xsl:template name="printLinks">
		<xsl:param name="element"></xsl:param>
		<xsl:param name="nodeset"></xsl:param>
		<xsl:param name="metaclasses"></xsl:param>
			
		<xsl:variable name="first" select="$metaclasses[1]"></xsl:variable>
		<xsl:if test="$first">
			<xsl:variable name="p_name" select="string($first)"></xsl:variable>

			<xsl:if test="string-length($p_name) &gt; 0">
			<!-- Heading (small table with link metaclass inside) -->
			<p/>
			<table border="0" cellpadding="0" cellspacing="0">
			<tr class="TableHeaderStyle">
			<td>
			<font size="+0">
			<b><xsl:value-of select="$p_name"/></b>
			</font>
			</td>
			</tr>
			</table>
			<br/>

			<!-- Links of selected metaclass -->
			<xsl:for-each select="$element/Link[@metaclass=$p_name]">

				<xsl:variable name="destination" select="key('all-by-id', @idref)"></xsl:variable>
				<xsl:variable name="ref">
					<xsl:call-template name="RelPathResolver">
						<xsl:with-param name="element" select="$destination"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
	
				<xsl:variable name="to">
					<xsl:choose>
						<xsl:when test="local-name($destination)='Package'">
							<xsl:call-template name="getLocalizedResource">
								<xsl:with-param name="code" select="'Package_1'"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="local-name($destination)='Classifier'">
							<xsl:call-template name="getLocalizedClassType">
								<xsl:with-param name="type" select="$destination/@type"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$destination/@metaclass"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				
				<xsl:variable name="refpath">
					<xsl:apply-templates select="$destination" mode="HRefWithImgLoad"/>
				</xsl:variable>

				<xsl:choose>
					<xsl:when test="string-length(string($ref)) &gt; 0">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
							<xsl:with-param name="p1" select="$to"></xsl:with-param>
							<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
							<xsl:with-param name="p1" select="$to"></xsl:with-param>
							<xsl:with-param name="p2" select="$destination/@name"></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<p/>
				<xsl:call-template name="printProperties">
					<xsl:with-param name="element" select="current()"></xsl:with-param>
					<xsl:with-param name="nodeset" select="Property"></xsl:with-param>
					<xsl:with-param name="property-names" select="Property/@name"></xsl:with-param>			
				</xsl:call-template>
				
				<br/>

			</xsl:for-each>
			</xsl:if>

			<xsl:call-template name="printLinks">
				<xsl:with-param name="element" select="$element"></xsl:with-param>
				<xsl:with-param name="nodeset" select="$nodeset"></xsl:with-param>
				<xsl:with-param name="metaclasses" select="$metaclasses[not(string($p_name)=string(.))]"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="printInnerLinks">
		<xsl:param name="element"/>
		<xsl:param name="metaclasses"/>
		<xsl:param name="link_refs"/>
			
		<!-- for links, which entity is not child of parent reference entity-->
		
		<xsl:variable name="first" select="$metaclasses[1]"></xsl:variable>
		<xsl:if test="$first">
	
			<xsl:variable name="p_name" select="string($first)"></xsl:variable>
			<xsl:if test="string-length($p_name) &gt; 0">

		<xsl:for-each select="$element/DesignElement//Link[@metaclass=$p_name]">
				
			<xsl:variable name="linkref" select="$link_refs[@element=current()/@id]"/>
			<!-- if link reference exist in Diagram -->
			<xsl:if test="string-length($linkref) &gt; 0">
				<!-- if parent of link reference is reference to element - we add this link to element -->
				<xsl:if test="$linkref/../@element=$element/@id">
					
					<!-- Heading (small table with link metaclass inside) -->
					<p/>
					<table border="0" cellpadding="0" cellspacing="0">
					<tr class="TableHeaderStyle">
					<td>
					<font size="+0">
					<b><xsl:value-of select="$p_name"/></b>
					</font>
					</td>
					</tr>
					</table>
					<br/>
			
					<!-- search for destination -->
					<xsl:variable name="destination" select="key('all-by-id', current()/@idref)"/>
					<xsl:variable name="newdest" select="($destination/ancestor::DesignElement[string-length($link_refs/@element=@id) &gt; 0])[position()=last()]"/>
					<xsl:variable name="ref">
						<xsl:call-template name="RelPathResolver">
							<xsl:with-param name="element" select="$newdest"></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
				
					<xsl:variable name="to">
						<xsl:choose>
							<xsl:when test="local-name($newdest)='Package'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'Package_1'"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="local-name($newdest)='Classifier'">
								<xsl:call-template name="getLocalizedClassType">
									<xsl:with-param name="type" select="$newdest/@type"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$newdest/@metaclass"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
							
					<xsl:variable name="refpath">
						<xsl:apply-templates select="$newdest" mode="HRefWithImgLoad"/>
					</xsl:variable>

					<xsl:choose>
						<xsl:when test="string-length(string($ref)) &gt; 0">
							<xsl:call-template name="getLocalizedResource">
								<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
								<xsl:with-param name="p1" select="$to"></xsl:with-param>
								<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="getLocalizedResource">
								<xsl:with-param name="code" select="'link_to'"></xsl:with-param>
								<xsl:with-param name="p1" select="$to"></xsl:with-param>
								<xsl:with-param name="p2" select="$newdest/@name"></xsl:with-param>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
					<p/>
					<xsl:call-template name="printProperties">
						<xsl:with-param name="element" select="current()"></xsl:with-param>
						<xsl:with-param name="nodeset" select="Property"></xsl:with-param>
						<xsl:with-param name="property-names" select="Property/@name"></xsl:with-param>			
					</xsl:call-template>
							
					<xsl:variable name="refproperties" select="$linkref/Property"></xsl:variable>
					<xsl:call-template name="printProperties">
						<xsl:with-param name="element" select="$linkref"></xsl:with-param>
						<xsl:with-param name="nodeset" select="$refproperties[not(@name=current()/Property/@name)]"></xsl:with-param>
						<xsl:with-param name="property-names" select="$refproperties[not(@name=current()/Property/@name)]/@name"></xsl:with-param>
					</xsl:call-template>
					<br/>
				</xsl:if>
			</xsl:if>
		</xsl:for-each>
		</xsl:if>
			
			<xsl:call-template name="printInnerLinks">
				<xsl:with-param name="element" select="$element"></xsl:with-param>
				<xsl:with-param name="metaclasses" select="$metaclasses[not(string($p_name)=string(.))]"></xsl:with-param>
				<xsl:with-param name="link_refs" select="$link_refs"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		
	</xsl:template>
</xsl:stylesheet>
